/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.common.connection;

import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.GlobalPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import sonar.fluxnetworks.api.device.FluxDeviceType;
import sonar.fluxnetworks.api.device.IFluxDevice;
import sonar.fluxnetworks.common.connection.FluxMenu;
import sonar.fluxnetworks.common.device.TileFluxDevice;
import sonar.fluxnetworks.common.util.FluxUtils;

public class PhantomFluxDevice
implements IFluxDevice {
    private int mNetworkID;
    private String mCustomName;
    private int mPriority;
    private long mLimit;
    private UUID mOwnerUUID;
    private FluxDeviceType mDeviceType;
    private GlobalPos mGlobalPos;
    private boolean mSurgeMode;
    private boolean mDisableLimit;
    private boolean mChunkLoaded;
    private boolean mForcedLoading;
    private long mBuffer;
    private long mChange;
    private ItemStack mDisplayStack;

    @Nonnull
    public static PhantomFluxDevice makeUnloaded(@Nonnull TileFluxDevice device) {
        PhantomFluxDevice t = new PhantomFluxDevice();
        t.mNetworkID = device.getNetworkID();
        t.mCustomName = device.getCustomName();
        t.mPriority = device.getRawPriority();
        t.mLimit = device.getRawLimit();
        t.mOwnerUUID = device.getOwnerUUID();
        t.mDeviceType = device.getDeviceType();
        t.mGlobalPos = device.getGlobalPos();
        t.mSurgeMode = device.getSurgeMode();
        t.mDisableLimit = device.getDisableLimit();
        t.mBuffer = device.getTransferBuffer();
        t.mDisplayStack = device.getDisplayStack();
        return t;
    }

    @Nonnull
    public static PhantomFluxDevice makeUpdated(@Nonnull GlobalPos pos, @Nonnull CompoundTag tag) {
        PhantomFluxDevice t = new PhantomFluxDevice();
        t.mGlobalPos = pos;
        t.readCustomTag(tag, (byte)20);
        return t;
    }

    @Nonnull
    public static PhantomFluxDevice make(@Nonnull CompoundTag tag) {
        PhantomFluxDevice t = new PhantomFluxDevice();
        t.readCustomTag(tag, (byte)1);
        return t;
    }

    @Override
    public void writeCustomTag(@Nonnull CompoundTag tag, byte type) {
        if (type == 1 || type == 20) {
            FluxUtils.writeGlobalPos(tag, this.mGlobalPos);
            tag.m_128344_("deviceType", this.mDeviceType.getId());
            tag.m_128405_("networkID", this.mNetworkID);
            tag.m_128359_("customName", this.mCustomName);
            tag.m_128405_("priority", this.mPriority);
            tag.m_128356_("limit", this.mLimit);
            tag.m_128379_("surgeMode", this.mSurgeMode);
            tag.m_128379_("disableLimit", this.mDisableLimit);
            tag.m_128362_("playerUUID", this.mOwnerUUID);
            tag.m_128356_("buffer", this.mBuffer);
            this.mDisplayStack.m_41739_(tag);
        }
    }

    @Override
    public void readCustomTag(@Nonnull CompoundTag tag, byte type) {
        if (type == 1) {
            this.mGlobalPos = FluxUtils.readGlobalPos(tag);
        }
        if (type == 1 || type == 20) {
            this.mDeviceType = FluxDeviceType.fromId(tag.m_128445_("deviceType"));
            this.mNetworkID = tag.m_128451_("networkID");
            this.mCustomName = tag.m_128461_("customName");
            this.mPriority = tag.m_128451_("priority");
            this.mLimit = tag.m_128454_("limit");
            this.mSurgeMode = tag.m_128471_("surgeMode");
            this.mDisableLimit = tag.m_128471_("disableLimit");
            this.mOwnerUUID = tag.m_128342_("playerUUID");
            this.mBuffer = tag.m_128454_("buffer");
            this.mDisplayStack = ItemStack.m_41712_((CompoundTag)tag);
        }
        if (type == 20) {
            this.mForcedLoading = tag.m_128471_("forcedLoading");
            this.mChunkLoaded = tag.m_128471_("chunkLoaded");
            this.mChange = tag.m_128454_("change");
        }
    }

    @Override
    public int getNetworkID() {
        return this.mNetworkID;
    }

    @Override
    public void onPlayerOpened(@Nonnull Player player) {
        throw new IllegalStateException("Logic method cannot be invoked on phantom device");
    }

    @Override
    public void onPlayerClosed(@Nonnull Player player) {
        throw new IllegalStateException("Logic method cannot be invoked on phantom device");
    }

    @Override
    public int getRawPriority() {
        return this.mPriority;
    }

    @Override
    @Nonnull
    public UUID getOwnerUUID() {
        return this.mOwnerUUID;
    }

    @Override
    @Nonnull
    public FluxDeviceType getDeviceType() {
        return this.mDeviceType;
    }

    @Override
    public boolean isChunkLoaded() {
        return this.mChunkLoaded;
    }

    @Override
    public boolean isForcedLoading() {
        return this.mForcedLoading;
    }

    @Override
    public long getRawLimit() {
        return this.mLimit;
    }

    @Override
    public long getMaxTransferLimit() {
        throw new IllegalStateException("Logic method cannot be invoked on phantom device");
    }

    @Override
    @Nonnull
    public GlobalPos getGlobalPos() {
        return this.mGlobalPos;
    }

    @Override
    @Nonnull
    public String getCustomName() {
        return this.mCustomName;
    }

    @Override
    public boolean getDisableLimit() {
        return this.mDisableLimit;
    }

    @Override
    public boolean getSurgeMode() {
        return this.mSurgeMode;
    }

    @Override
    @Nonnull
    public ItemStack getDisplayStack() {
        return this.mDisplayStack;
    }

    @Override
    public long getTransferBuffer() {
        return this.mBuffer;
    }

    @Override
    public long getTransferChange() {
        return this.mChange;
    }

    @Nullable
    public FluxMenu createMenu(int containerId, @Nonnull Inventory inventory, @Nonnull Player player) {
        throw new IllegalStateException("Logic method cannot be invoked on phantom device");
    }
}

